{/ JBK 16 Client - Long file names for 16-bit OWL applications through DDE
//
// Version 1.0 - Freeware. Please modify as needed.
//
// (c) JBK Data 1997
//     CSID 100776,1403
//     e-mail Jens_B_Kristensen@compuserve.com
/}

unit Lfn_wnd;
{
TLFN_Window is a basic OWL window with access to long filenames
via a DDE connection to the 32-bit DDE server.

Requires Delphi 1 and the OWL source code (Rtl70) to compile.

NOTE: It's much easier to mix 'new' and 'old' style objects than the
documentation wants you to believe.
}

interface
uses
  Messages,
  WinTypes,
  WinProcs,
  OWindows,
  ODialogs,
  Sysutils,
  jbkutils,
  commctrl,
  Ddeunit;
type

  {Modified application object. First version made GPF error on shutdown,
  I found that I could eliminate the error by removing some lines from the
  ProcessAppMsg procedure. See below}
  TlfnApp = object(TApplication)
    function ProcessAppMsg(var Message: TMsg): Boolean;virtual;
  end;

  {OWL window object with access to long filenames}
  PLFNWindow = ^TLFNWindow;
  TLFNWindow = object(TWindow)
    opening,saving:boolean;
    constructor init(aparent:Pwindowsobject;aname:pchar);
    procedure SetupWindow ; virtual;
    function  GetClassName : PChar;virtual;
    procedure GetWindowClass(var AWndClass : TWndClass);virtual;
    function  CanClose : boolean; virtual;
    procedure wmactivate(var msg:Tmessage);virtual wm_first + wm_activate;
    procedure showlfnopendialog;virtual;
    procedure showlfnsaveasdialog;virtual;
    destructor Done; virtual;
  end;

implementation
constructor TLFNWindow.init(aparent:Pwindowsobject;aname:pchar);
begin
   inherited init(aparent,aname);
   opening:=false;
   saving:=false;
end;

procedure TLFNWindow.SetupWindow;
var h:Hwnd;
begin
   inherited SetupWindow;
   if windows95 then
   begin
      {Create the DDEform, wait for the Server app. to launch and
      then hide it}
      DDEform:=TDDEform.create(nil);
      repeat
         h:=findwindow(nil,'JBK 32 server');
         wait(100);
      until h<>0;
      showwindow(h,sw_hide);
   end;
end;

{-------TLFNWindow.GetClassName}
function TLFNWindow.GetClassName : PChar;
begin
   {The classname is used when the DDE Server wants
   to communicate with the 16-bit application. So don't change it,
   or change it everywhere, also on the 32-bit side}
   GetClassName := 'LFNWindow';
end;

{-------TLFNWindow.GetWindowClass}
procedure TLFNWindow.GetWindowClass(var AWndClass : TWndClass);
begin
 inherited GetWindowClass(AWndClass);
end;


{-----------------TLFNWindow.CanClose}
function TLFNWindow.CanClose : boolean; 
var
  resultat:boolean;h:hwnd;
begin
resultat:=inherited canclose;
if windows95 then
  if resultat then
  begin
     {if allowed to close, close the DDEform and wait for
     it to disappear before proceeding}
     h:=DDEform.handle;
     DDEform.release;
     while iswindow(h) do wait(100);
  end;
CanClose := Resultat;
end;

procedure TLFNWindow.wmactivate;
{Bring the dialog box to the front if the user tries to
switch to the main window. Room for improvement here.}
var h:hwnd;
begin

   if windows95 and (msg.wparam<>wa_inactive) then
   begin
      h:=findwindow(nil,'LFN Open');
      if iswindow(h) then
         bringwindowtotop(h)
      else
      h:=findwindow(nil,'LFN Save As');
      if iswindow(h) then
         bringwindowtotop(h);
   end
   else
      inherited wmactivate(msg);
end;


procedure TLFNWindow.showlfnopendialog;
{Activates the Explorer Open-dialog through DDE}
var h:hwnd;
begin
   {Find ther server's main form}
   h:=findwindow(nil,'JBK 32 server');
   {Bring server to the front and 'poke' the longfilename to it}
   bringwindowtotop(h);
   DDEform.ddeclientconv1.pokedata('DdeServerOpenLongname',longfilename);
end;

procedure TLFNWindow.showlfnsaveasdialog;
{Similar to above. Se comments there}
var h:hwnd;
begin
   begin
      h:=findwindow(nil,'JBK 32 server');
      bringwindowtotop(h);
      DDEform.ddeclientconv1.pokedata('DdeServerSaveLongname',longfilename);
   end;
end;


{------TLFNWindow.Done}
destructor TLFNWindow.Done;
var h:hwnd;
begin
   {Shut down the server. Possible because the DDEform has been freed}
   if windows95 then
   begin
      h:=findwindow(nil,'JBK 32 server');
      postmessage(h,wm_close,0,0);
   end;
   inherited Done;
end;

{--------TLFNApp}
function TLFNApp.ProcessAppMsg(var Message: TMsg): Boolean;
{One line removed to avoid GPF's. I don't know what ProcessMDIAccels
does anyway; probably nothing because this is not an MDI application}
begin
  ProcessAppMsg :=
    ProcessDlgMsg(Message) or
    {ProcessMDIAccels(Message) or}
    ProcessAccels(Message);
end;

end.
